%Detect the optimal number of clusters from tSNE feature space using bisecting kmeans
%   Input:
%       1- mappedX: tSNE result
%       2- S: the size of the original data (considering the background) 
%       3- indx: indices where tSNE was applied (helps if the background
%       was excluded)

function [K_Clusters,R, IDXs, Cs] = Optimal_NumberClusters(mappedX,S,indx)

% % If you don't to use the normalized values
tSNE_SegmentationMap = Visualize_tSNE_2DImage(mappedX,S(1),S(2),indx);
S_I = size(tSNE_SegmentationMap);
h = fspecial('average');
if(size(tSNE_SegmentationMap,3) == 3)
    
     tSNE_SegMap_Gray = (tSNE_SegmentationMap(:,:,1) +  tSNE_SegmentationMap(:,:,2) + tSNE_SegmentationMap(:,:,3))./3;

else
    tSNE_SegMap_Gray = tSNE_SegmentationMap;
end
h = fspecial('average');
tSNE_SegMap_Grayh = imfilter(tSNE_SegMap_Gray,h);
Id = edge(tSNE_SegMap_Grayh,'canny');


%% Step2: Apply kmeans and correlate with the normalized tSNE to get the
%optimal number of clusters
% opts = statset('MaxIter',300,'Display','final');
opts = statset('MaxIter',300);

N_Clusters = 10;
for i = 2:N_Clusters
opt=[1E-6 1 1];
[IDX,C,CovMat,Dmat,Co]=MyKmeans(mappedX,i,opt); %Bisecting k-means
[Kmeans_SegmentationMap,IDXs,Cs, Color_Scheme] = Visualize_combined_ClusteredImage(IDX,C,S,indx,i);

% Edge Detection on k-means spatial image
Kd = edge(Kmeans_SegmentationMap,'canny',0.01);
% Pearson correlation on the edge images (i.e. gradient correlations)
R(i) = corr2(Kd(:),Id(:));
end
clear IDX C;
% Choose the k-clusters with the maximum gradient correlation value
[Max_Corr,K_Clusters] = max(R)
opt=[1E-6 1 1];
[IDX,C,CovMat,Dmat,Co]=MyKmeans(mappedX,K_Clusters,opt);
% % %  IDX = emgm(mappedX',K_Clusters)';
[Kmeans_SegmentationMap, IDXs, Cs, Color_Scheme] = Visualize_combined_ClusteredImage(IDX,C,S,indx,K_Clusters);
figure,plot(2:N_Clusters,R(2:N_Clusters)); xlabel('Clusters(K)'); ylabel('Pearson Correlation');

